<?php

use App\Http\Controllers\Api\AuthUserController;
use App\Http\Controllers\Api\CarController;
use App\Http\Controllers\Api\ChatController;
use App\Http\Controllers\Api\CommentController;
use App\Http\Controllers\Api\EventsController;
use App\Http\Controllers\Api\MediaController;
use App\Http\Controllers\Api\PostController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\ClubController;
use App\Http\Controllers\Api\CareerController;
use App\Http\Controllers\Api\MotoController;
use App\Http\Controllers\Api\AcademyController;
use App\Http\Controllers\Api\ChampionController;
use App\Http\Controllers\Api\CategoryController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(['prefix' => 'auth'], function () {
    Route::post('register', [AuthUserController::class , 'register']);
    Route::post('complete-register', [AuthUserController::class , 'complete_register']);
    Route::post('login', [AuthUserController::class , 'login']);
    Route::post('logout', [AuthUserController::class , 'logout']);
    Route::post('forget-password', [AuthUserController::class , 'forgetPassword']);
    Route::post('check-forget-code', [AuthUserController::class , 'check_forget_code']);
    Route::post('reset-password', [AuthUserController::class , 'resetPassword']);
    Route::get('interests', [AuthUserController::class , 'get_interests']);
});

Route::group(['prefix' => 'profile'], function () {
    Route::post('update', [ProfileController::class , 'update_profile']);
    Route::post('update-interests', [ProfileController::class , 'update_interests']);
    Route::post('update-image', [ProfileController::class , 'update_image']);
    Route::post('update-background-image', [ProfileController::class , 'update_background_image']);
    Route::get('notifications', [ProfileController::class , 'notifications']);
    Route::post('/user', [ProfileController::class , 'user_info']);
    Route::post('/follow', [ProfileController::class , 'follow_profile']);
    Route::post('/follow-users', [ProfileController::class , 'follow_users']);
    Route::post('/add-crew', [ProfileController::class , 'add_crew']);
    Route::post('/remove-from-crew', [ProfileController::class , 'remove_from_crew']);
    Route::get('/my-crew', [ProfileController::class , 'my_crew']);
    Route::post('/search', [ProfileController::class , 'search']);
    Route::get('/countries', [ProfileController::class , 'countries']);
    Route::get('/cities', [ProfileController::class , 'cities']);
    Route::get('/nationalities', [ProfileController::class , 'nationalities']);
    Route::get('/regions', [ProfileController::class , 'regions']);
    Route::get('/random_users', [ProfileController::class , 'random_users']);

});

Route::group(['prefix' => 'settings'], function () {
    Route::get('about-app', [SettingController::class , 'get_about_app']);
    Route::get('terms-conditions', [SettingController::class , 'get_terms_and_conditions']);
    Route::get('privacy-policy', [SettingController::class , 'get_privacy_policy']);
});

Route::group(['prefix' => 'posts'], function () {
    Route::get('/', [PostController::class , 'get_posts']);
    Route::post('/posts-by-type', [PostController::class , 'get_posts_by_type']);
    Route::post('/posts-by-privacy', [PostController::class , 'get_posts_by_users']);
    Route::post('/show', [PostController::class , 'show_post']);
    Route::post('/new', [PostController::class , 'new_post']);
    Route::post('/edit', [PostController::class , 'edit_post']);
    Route::post('/delete', [PostController::class , 'delete_post']);
    Route::get('/show_vons', [PostController::class , 'show_vons']);
    Route::post('/like', [PostController::class , 'post_like']);
    Route::post('/user', [PostController::class , 'post_by_user']);
});

Route::group(['prefix' => 'comments'], function () {
    Route::post('/', [CommentController::class , 'comments']);
    Route::post('/new', [CommentController::class , 'new_comment']);
    Route::post('/edit', [CommentController::class , 'edit_comment']);
    Route::post('/delete', [CommentController::class , 'delete_comment']);
});

Route::group(['prefix' => 'chat'], function () {
    Route::get('/history', [ChatController::class , 'chat_history']);
    Route::get('/messages', [ChatController::class , 'chat_messages']);
    Route::post('send-message', [ChatController::class , 'send_message']);
});

Route::group(['prefix' => 'media'], function () {
    Route::post('/info', [MediaController::class , 'get_media_data']);
    Route::post('/by-type', [MediaController::class , 'get_media_by_type']);
    Route::post('/add-new-album', [MediaController::class , 'add_new_album']);
    Route::post('/albums', [MediaController::class , 'get_albums']);
    Route::post('/album/images', [MediaController::class , 'get_album_images']);
    Route::post('new-camera',[MediaController::class,'add_new_camera']);
    Route::post('remove-camera',[MediaController::class,'remove_camera']);
    Route::get('get-camera',[MediaController::class,'get_cameras']);
    Route::get('get-lenses',[MediaController::class,'get_lenses']);
    Route::post('add-album-media',[MediaController::class,'add_album_media']);
    Route::post('add-lens',[MediaController::class,'add_lens']);
    Route::post('remove-lens',[MediaController::class,'remove_lens']);
    Route::get('job-titles', [MediaController::class , 'job_titles']);
    Route::post('remove-album',[MediaController::class,'remove_album']);
    Route::post('remove-album-media',[MediaController::class,'remove_album_media']);
    
    
    Route::get('get-my-cameras',[MediaController::class,'get_my_cameras']);
    Route::get('get-my-lenses',[MediaController::class,'get_my_lenses']);
    Route::get('get-my-crews',[MediaController::class,'get_my_crews']);
    Route::post('update-media',[MediaController::class,'update_album_media']);
    
   Route::get('get-my-medias',[MediaController::class,'get_my_media_data']);
    
    
    
});


Route::group(['prefix' => 'events'], function () {
    Route::get('/', [EventsController::class , 'get_events']);
    Route::post('/user_events', [ChampionController::class , 'user_events']);
    Route::post('/user', [EventsController::class , 'get_user_events']);
    Route::post('/save', [EventsController::class , 'save_event']);
    Route::post('/update', [EventsController::class , 'update_event']);
    Route::post('/delete', [EventsController::class , 'delete_event']);
});


Route::group(['prefix' => 'clubs'], function () {
    Route::post('/', [ClubController::class , 'clubs']);
    Route::get('/members', [ClubController::class , 'club_members']);
    Route::post('/save-club', [ClubController::class , 'save_club']);
    Route::post('/save-club-member', [ClubController::class , 'save_club_member']);
    Route::post('/update-club', [ClubController::class , 'update_club']);
    Route::post('/update-club-member', [ClubController::class , 'update_club_member']);
    Route::post('/delete-club', [ClubController::class , 'delete_club']);
    Route::post('/delete-club-member', [ClubController::class , 'delete_club_member']);
});


Route::group(['prefix' => 'careers'], function () {
    Route::get('/', [CareerController::class , 'careers']);
    Route::post('/save', [CareerController::class , 'save_career']);
    Route::post('/update', [CareerController::class , 'update_career']);
    Route::post('/delete', [CareerController::class , 'delete_career']);
});


Route::group(['prefix' => 'academies'], function () {
    Route::post('/', [AcademyController::class , 'academies']);
    Route::post('/save', [AcademyController::class , 'save_academy']);
    Route::post('/update', [AcademyController::class , 'update_career']);
    Route::post('/delete', [AcademyController::class , 'delete_career']);
});


Route::group(['prefix' => 'categories'], function () {
    Route::get('/{type}', [CategoryController::class , 'categories']);
});

Route::group(['prefix' => 'courses'], function () {
    Route::post('/', [AcademyController::class , 'courses']);
    Route::post('/save', [AcademyController::class , 'save_course']);
    Route::post('/update', [AcademyController::class , 'update_career']);
    Route::post('/delete', [AcademyController::class , 'delete_career']);
});


Route::group(['prefix' => 'champions'], function () {
    Route::post('/', [ChampionController::class , 'champions']);
    Route::post('/save', [ChampionController::class , 'save_career']);
    Route::post('/update', [ChampionController::class , 'update_career']);
    Route::post('/delete', [ChampionController::class , 'delete_career']);
});





Route::group(['prefix' => 'cars'], function () {

    Route::post('/', [CarController::class , 'get_cars']);
    Route::post('/info', [CarController::class , 'get_car_details']);
    Route::post('/participations', [CarController::class , 'get_participations']);
    Route::post('/participations/save', [CarController::class , 'set_participations']);
    Route::post('/participations/remove', [CarController::class , 'remove_participations']);
    Route::get('/coil-overs', [CarController::class , 'get_coil_overs']);
    Route::get('/brake-kits', [CarController::class , 'get_brake_kits']);
    Route::get('/control-arms', [CarController::class , 'get_control_arms']);
    Route::get('/hydraulic-hand-brakes', [CarController::class , 'get_hydraulic_hand_brakes']);
    Route::get('/injectors', [CarController::class , 'get_injectors']);
    Route::get('/fuel-bumps', [CarController::class , 'get_fuel_bumps']);
    Route::get('/fuel-regulars', [CarController::class , 'get_fuel_regulars']);
    Route::get('/exhausts', [CarController::class , 'get_exhausts']);
    Route::get('/headers', [CarController::class , 'get_headers']);
    Route::get('/manifolds', [CarController::class , 'get_manifolds']);
    Route::get('/mid-pipes', [CarController::class , 'get_mid_pipes']);
    Route::get('/down-pipes', [CarController::class , 'get_down_pipes']);
    Route::get('/rear-sections', [CarController::class , 'get_rear_sections']);
    Route::get('/steering-angels', [CarController::class , 'get_steering_angels']);
    Route::get('/steering-boxes', [CarController::class , 'get_steering_boxes']);
    Route::get('/tier-brands', [CarController::class , 'get_tier_brands']);
    Route::get('/rim-brands', [CarController::class , 'get_rim_brands']);
    Route::get('/rim-sizes', [CarController::class , 'get_rim_sizes']);
    Route::get('/ignition-calls', [CarController::class , 'get_ignition_calls']);
    Route::get('/spark_plugs', [CarController::class , 'get_spark_plugs']);
    Route::get('/linking-wires', [CarController::class , 'get_linking_wires']);
    Route::get('/ecu-ignition-calls', [CarController::class , 'get_ecu_ignition_calls']);
    Route::get('/coolings', [CarController::class , 'get_coolings']);
    Route::get('/filter-intakes', [CarController::class , 'get_filter_intakes']);
    Route::get('/interiors', [CarController::class , 'get_interiors']);
    Route::get('/oils', [CarController::class , 'get_oils']);
    Route::get('/exteriors', [CarController::class , 'get_exteriors']);
    Route::get('/engine-brands', [CarController::class , 'get_engine_brands']);
    Route::get('/engine-year/{make_id}', [CarController::class , 'get_engine_year']);
    Route::get('/no-cylinders/{make_id}/{year_id}', [CarController::class , 'get_no_cylinders']);
    Route::get('/engine-cc/{make_id}/{year_id}/{cylinder_id}', [CarController::class , 'get_engine_cc']);
    Route::get('/nos', [CarController::class , 'get_nos']);
    Route::get('/na-super-chargo-turbos', [CarController::class , 'get_na_super_chargo_turbos']);



    Route::get('/pistons', [CarController::class , 'get_pistons']);
    Route::get('/connecting-rods', [CarController::class , 'get_connecting_rods']);
    Route::get('/cranks', [CarController::class , 'get_cranks']);
    Route::get('/cams', [CarController::class , 'get_cams']);
    Route::get('/value-springs', [CarController::class , 'get_value_springs']);
    Route::get('/retainers', [CarController::class , 'get_retainers']);
    Route::get('/transmutations', [CarController::class , 'get_transmutations']);
    Route::get('/differentials', [CarController::class , 'get_differentials']);
    Route::get('/clutches', [CarController::class , 'get_clutches']);
    Route::get('/fly_wheels', [CarController::class , 'get_fly_wheels']);


    Route::get('/car_make', [CarController::class , 'get_car_makes']);

    Route::get('/car_years/{make_id}', [CarController::class , 'get_car_years']);

    Route::get('/car_models/{make_id}/{year_id}', [CarController::class , 'get_car_models']);

    Route::get('/car_model_versions/{make_id}/{year_id}/{model_id}', [CarController::class , 'get_car_model_versions']);


    Route::post('/save', [CarController::class , 'save_car']);
    Route::post('/remove', [CarController::class , 'remove_car']);
    
    
    Route::get('/turbo_kits', [CarController::class , 'get_turbo_kits']);
     Route::get('/blow_of_valves', [CarController::class , 'get_blow_of_valves']);
      Route::get('/wastgates', [CarController::class , 'get_wastgates']);
       Route::get('/boost_controllers', [CarController::class , 'get_boost_controllers']);
       
        Route::get('/super_charge_kits', [CarController::class , 'get_super_charge_kits']);
    
    
});


Route::get('/data', [CarController::class , 'addData']);


Route::group(['prefix' => 'moto'], function () {
    Route::get('/air-filter', [MotoController::class , 'get_moto_air_filter']);
    Route::get('/blow-of-valve', [MotoController::class , 'get_moto_blow_of_valve']);
    Route::get('/boost-controller', [MotoController::class , 'get_moto_boost_controller']);
    Route::get('/brake-line', [MotoController::class , 'get_moto_brake_line']);
    Route::get('/brake-master-cylinder', [MotoController::class , 'get_moto_brake_master_cylinder']);
    Route::get('/brake-pad', [MotoController::class , 'get_moto_brake_pad']);
    Route::get('/brake-rotor', [MotoController::class , 'get_moto_brake_rotor']);
    Route::get('/caliper', [MotoController::class , 'get_moto_caliper']);
    Route::get('/cam-shaft', [MotoController::class , 'get_moto_cam_shaft']);
    Route::get('/clutch', [MotoController::class , 'get_moto_clutch']);
    Route::get('/connecting-rod', [MotoController::class , 'get_moto_connecting_rod']);
    Route::get('/control', [MotoController::class , 'get_moto_control']);
    Route::get('/cooling-system', [MotoController::class , 'get_moto_cooling_system']);
    Route::get('/crank-shaft', [MotoController::class , 'get_moto_crank_shaft']);
    Route::get('/crash-bar', [MotoController::class , 'get_moto_crash_bar']);
    Route::get('/ecu', [MotoController::class , 'get_moto_ecu']);
    Route::get('/engine-brand', [MotoController::class , 'get_moto_engine_brand']);
    Route::get('/engine-guard', [MotoController::class , 'get_moto_engine_guard']);
    Route::get('/engine-model', [MotoController::class , 'get_moto_engine_model']);
    Route::get('/engine-year', [MotoController::class , 'get_moto_engine_year']);
    Route::get('/final-drive', [MotoController::class , 'get_moto_final_drive']);
    Route::get('/fork', [MotoController::class , 'get_moto_fork']);
    Route::get('/fuelinjector', [MotoController::class , 'get_moto_fuelinjector']);
    Route::get('/fuel-management', [MotoController::class , 'get_moto_fuel_management']);
    Route::get('/header', [MotoController::class , 'get_moto_header']);
    Route::get('/hyper-charge', [MotoController::class , 'get_moto_hyper_charge']);
    Route::get('/ignition', [MotoController::class , 'get_moto_ignition']);
    Route::get('/lowering-link', [MotoController::class , 'get_moto_lowering_link']);
    Route::get('/manifold', [MotoController::class , 'get_moto_manifold']);
    Route::get('/na-super-chrage-turbo', [MotoController::class , 'get_moto_na_super_chrage_turbo']);
    Route::get('/moto-nos', [MotoController::class , 'get_moto_nos']);
    Route::get('/pipe', [MotoController::class , 'get_moto_pipe']);
    Route::get('/piston', [MotoController::class , 'get_moto_piston']);
    Route::get('/primary-drive', [MotoController::class , 'get_moto_primary_drive']);
    Route::get('/rims-brand', [MotoController::class , 'get_moto_rims_brand']);
    Route::get('/rims-size', [MotoController::class , 'get_moto_rims_size']);
    Route::get('/seat', [MotoController::class , 'get_moto_seat']);
    Route::get('/shock', [MotoController::class , 'get_moto_shock']);
    Route::get('/silpone', [MotoController::class , 'get_moto_silpone']);
    Route::get('/sprocket', [MotoController::class , 'get_moto_sprocket']);
    Route::get('/tires-brand', [MotoController::class , 'get_moto_tires_brand']);
    Route::get('/turbo-kit', [MotoController::class , 'get_moto_turbo_kit']);
    Route::get('/valve', [MotoController::class , 'get_moto_valve']);
    Route::get('/westgate', [MotoController::class , 'get_moto_westgate']);
    Route::post('/save', [MotoController::class , 'save_moto']);
});

